/******************************************************************************
 * Filename:       Digital_Input_Service.c
 *
 * Description:    This file contains the implementation of the service.
 *
 *                 Generated by:
 *                 BDS version: 1.1.3135.0
 *                 Plugin:      Texas Instruments BLE SDK GATT Server plugin 1.0.8
 *                 Time:        Sat Jun 24 2017 16:55:14 GMT+01:00
 *

 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 **********************************************************************************/


/*********************************************************************
 * INCLUDES
 */
#include <string.h>

//#define xdc_runtime_Log_DISABLE_ALL 1  // Add to disable logs from this file
#include <xdc/runtime/Log.h>
#include <xdc/runtime/Diags.h>

#include "bcomdef.h"
#include "OSAL.h"
#include "linkdb.h"
#include "att.h"
#include "gatt.h"
#include "gatt_uuid.h"
#include "gattservapp.h"
#include "gapbondmgr.h"

#ifdef ICALL_LITE
#  include "icall_api.h" // Only exists for 3.x stack version, so use ifdef.
#endif

#include "digital_input_service.h"

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * CONSTANTS
 */

/*********************************************************************
 * TYPEDEFS
 */

/*********************************************************************
* GLOBAL VARIABLES
*/

// Digital_Input_Service Service UUID
CONST uint8_t DigitalInputServiceUUID[ATT_UUID_SIZE] =
{
  DIGITAL_INPUT_SERVICE_SERV_UUID_BASE128(DIGITAL_INPUT_SERVICE_SERV_UUID)
};

// IN1 UUID
CONST uint8_t dis_IN1UUID[ATT_UUID_SIZE] =
{
  DIS_IN1_UUID_BASE128(DIS_IN1_UUID)
};

// IN2 UUID
CONST uint8_t dis_IN2UUID[ATT_UUID_SIZE] =
{
  DIS_IN2_UUID_BASE128(DIS_IN2_UUID)
};

// IN3 UUID
CONST uint8_t dis_IN3UUID[ATT_UUID_SIZE] =
{
  DIS_IN3_UUID_BASE128(DIS_IN3_UUID)
};


/*********************************************************************
 * LOCAL VARIABLES
 */

static DigitalInputServiceCBs_t *pAppCBs = NULL;
static uint8_t dis_icall_rsp_task_id = INVALID_TASK_ID;

/*********************************************************************
* Profile Attributes - variables
*/

// Service declaration
static CONST gattAttrType_t DigitalInputServiceDecl = { ATT_UUID_SIZE, DigitalInputServiceUUID };

// Characteristic "IN1" Properties (for declaration)
static uint8_t dis_IN1Props = GATT_PROP_NOTIFY | GATT_PROP_READ;

// Characteristic "IN1" Value variable
static uint8_t dis_IN1Val[DIS_IN1_LEN] = {0};

// Length of data in characteristic "IN1" Value variable, initialized to minimal size.
static uint16_t dis_IN1ValLen = DIS_IN1_LEN_MIN;

// Characteristic "IN1" Client Characteristic Configuration Descriptor
static gattCharCfg_t *dis_IN1Config;



// Characteristic "IN2" Properties (for declaration)
static uint8_t dis_IN2Props = GATT_PROP_NOTIFY | GATT_PROP_READ;

// Characteristic "IN2" Value variable
static uint8_t dis_IN2Val[DIS_IN2_LEN] = {0};

// Length of data in characteristic "IN2" Value variable, initialized to minimal size.
static uint16_t dis_IN2ValLen = DIS_IN2_LEN_MIN;

// Characteristic "IN2" Client Characteristic Configuration Descriptor
static gattCharCfg_t *dis_IN2Config;



// Characteristic "IN3" Properties (for declaration)
static uint8_t dis_IN3Props = GATT_PROP_NOTIFY | GATT_PROP_READ;

// Characteristic "IN3" Value variable
static uint8_t dis_IN3Val[DIS_IN3_LEN] = {0};

// Length of data in characteristic "IN3" Value variable, initialized to minimal size.
static uint16_t dis_IN3ValLen = DIS_IN3_LEN_MIN;

// Characteristic "IN3" Client Characteristic Configuration Descriptor
static gattCharCfg_t *dis_IN3Config;



/*********************************************************************
* Profile Attributes - Table
*/

static gattAttribute_t Digital_Input_ServiceAttrTbl[] =
{
  // Digital_Input_Service Service Declaration
  {
    { ATT_BT_UUID_SIZE, primaryServiceUUID },
    GATT_PERMIT_READ,
    0,
    (uint8_t *)&DigitalInputServiceDecl
  },
    // IN1 Characteristic Declaration
    {
      { ATT_BT_UUID_SIZE, characterUUID },
      GATT_PERMIT_READ,
      0,
      &dis_IN1Props
    },
      // IN1 Characteristic Value
      {
        { ATT_UUID_SIZE, dis_IN1UUID },
        GATT_PERMIT_READ,
        0,
        dis_IN1Val
      },
      // IN1 CCCD
      {
        { ATT_BT_UUID_SIZE, clientCharCfgUUID },
        GATT_PERMIT_READ | GATT_PERMIT_WRITE,
        0,
        (uint8_t *)&dis_IN1Config
      },
    // IN2 Characteristic Declaration
    {
      { ATT_BT_UUID_SIZE, characterUUID },
      GATT_PERMIT_READ,
      0,
      &dis_IN2Props
    },
      // IN2 Characteristic Value
      {
        { ATT_UUID_SIZE, dis_IN2UUID },
        GATT_PERMIT_READ,
        0,
        dis_IN2Val
      },
      // IN2 CCCD
      {
        { ATT_BT_UUID_SIZE, clientCharCfgUUID },
        GATT_PERMIT_READ | GATT_PERMIT_WRITE,
        0,
        (uint8_t *)&dis_IN2Config
      },
    // IN3 Characteristic Declaration
    {
      { ATT_BT_UUID_SIZE, characterUUID },
      GATT_PERMIT_READ,
      0,
      &dis_IN3Props
    },
      // IN3 Characteristic Value
      {
        { ATT_UUID_SIZE, dis_IN3UUID },
        GATT_PERMIT_READ,
        0,
        dis_IN3Val
      },
      // IN3 CCCD
      {
        { ATT_BT_UUID_SIZE, clientCharCfgUUID },
        GATT_PERMIT_READ | GATT_PERMIT_WRITE,
        0,
        (uint8_t *)&dis_IN3Config
      },
};

/*********************************************************************
 * LOCAL FUNCTIONS
 */
static bStatus_t Digital_Input_Service_ReadAttrCB( uint16_t connHandle, gattAttribute_t *pAttr,
                                           uint8_t *pValue, uint16_t *pLen, uint16_t offset,
                                           uint16_t maxLen, uint8_t method );
static bStatus_t Digital_Input_Service_WriteAttrCB( uint16_t connHandle, gattAttribute_t *pAttr,
                                            uint8_t *pValue, uint16_t len, uint16_t offset,
                                            uint8_t method );

/*********************************************************************
 * PROFILE CALLBACKS
 */
// Simple Profile Service Callbacks
CONST gattServiceCBs_t Digital_Input_ServiceCBs =
{
  Digital_Input_Service_ReadAttrCB,  // Read callback function pointer
  Digital_Input_Service_WriteAttrCB, // Write callback function pointer
  NULL                       // Authorization callback function pointer
};

/*********************************************************************
* PUBLIC FUNCTIONS
*/

/*
 * DigitalInputService_AddService- Initializes the DigitalInputService service by registering
 *          GATT attributes with the GATT server.
 *
 *    rspTaskId - The ICall Task Id that should receive responses for Indications.
 */
extern bStatus_t DigitalInputService_AddService( uint8_t rspTaskId )
{
  uint8_t status;

  // Allocate Client Characteristic Configuration table
  dis_IN1Config = (gattCharCfg_t *)ICall_malloc( sizeof(gattCharCfg_t) * linkDBNumConns );
  if ( dis_IN1Config == NULL )
  {
    return ( bleMemAllocError );
  }

  // Initialize Client Characteristic Configuration attributes
  GATTServApp_InitCharCfg( INVALID_CONNHANDLE, dis_IN1Config );
  // Allocate Client Characteristic Configuration table
  dis_IN2Config = (gattCharCfg_t *)ICall_malloc( sizeof(gattCharCfg_t) * linkDBNumConns );
  if ( dis_IN2Config == NULL )
  {
    return ( bleMemAllocError );
  }

  // Initialize Client Characteristic Configuration attributes
  GATTServApp_InitCharCfg( INVALID_CONNHANDLE, dis_IN2Config );
  // Allocate Client Characteristic Configuration table
  dis_IN3Config = (gattCharCfg_t *)ICall_malloc( sizeof(gattCharCfg_t) * linkDBNumConns );
  if ( dis_IN3Config == NULL )
  {
    return ( bleMemAllocError );
  }

  // Initialize Client Characteristic Configuration attributes
  GATTServApp_InitCharCfg( INVALID_CONNHANDLE, dis_IN3Config );
  // Register GATT attribute list and CBs with GATT Server App
  status = GATTServApp_RegisterService( Digital_Input_ServiceAttrTbl,
                                        GATT_NUM_ATTRS( Digital_Input_ServiceAttrTbl ),
                                        GATT_MAX_ENCRYPT_KEY_SIZE,
                                        &Digital_Input_ServiceCBs );
  Log_info1("Registered service, %d attributes", (IArg)GATT_NUM_ATTRS( Digital_Input_ServiceAttrTbl ));
  dis_icall_rsp_task_id = rspTaskId;

  return ( status );
}

/*
 * DigitalInputService_RegisterAppCBs - Registers the application callback function.
 *                    Only call this function once.
 *
 *    appCallbacks - pointer to application callbacks.
 */
bStatus_t DigitalInputService_RegisterAppCBs( DigitalInputServiceCBs_t *appCallbacks )
{
  if ( appCallbacks )
  {
    pAppCBs = appCallbacks;
    Log_info1("Registered callbacks to application. Struct %p", (IArg)appCallbacks);
    return ( SUCCESS );
  }
  else
  {
    Log_warning0("Null pointer given for app callbacks.");
    return ( FAILURE );
  }
}

/*
 * DigitalInputService_SetParameter - Set a DigitalInputService parameter.
 *
 *    param - Profile parameter ID
 *    len   - length of data to write
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
bStatus_t DigitalInputService_SetParameter( uint8_t param, uint16_t len, void *value )
{
  bStatus_t ret = SUCCESS;
  uint8_t  *pAttrVal;
  uint16_t *pValLen;
  uint16_t valMinLen;
  uint16_t valMaxLen;
  uint8_t sendNotiInd = FALSE;
  gattCharCfg_t *attrConfig;
  uint8_t needAuth;

  switch ( param )
  {
    case DIS_IN1_ID:
      pAttrVal  =  dis_IN1Val;
      pValLen   = &dis_IN1ValLen;
      valMinLen =  DIS_IN1_LEN_MIN;
      valMaxLen =  DIS_IN1_LEN;
      sendNotiInd = TRUE;
      attrConfig  = dis_IN1Config;
      needAuth    = FALSE; // Change if authenticated link is required for sending.
      Log_info2("SetParameter : %s len: %d", (IArg)"IN1", (IArg)len);
      break;

    case DIS_IN2_ID:
      pAttrVal  =  dis_IN2Val;
      pValLen   = &dis_IN2ValLen;
      valMinLen =  DIS_IN2_LEN_MIN;
      valMaxLen =  DIS_IN2_LEN;
      sendNotiInd = TRUE;
      attrConfig  = dis_IN2Config;
      needAuth    = FALSE; // Change if authenticated link is required for sending.
      Log_info2("SetParameter : %s len: %d", (IArg)"IN2", (IArg)len);
      break;

    case DIS_IN3_ID:
      pAttrVal  =  dis_IN3Val;
      pValLen   = &dis_IN3ValLen;
      valMinLen =  DIS_IN3_LEN_MIN;
      valMaxLen =  DIS_IN3_LEN;
      sendNotiInd = TRUE;
      attrConfig  = dis_IN3Config;
      needAuth    = FALSE; // Change if authenticated link is required for sending.
      Log_info2("SetParameter : %s len: %d", (IArg)"IN3", (IArg)len);
      break;

    default:
      Log_error1("SetParameter: Parameter #%d not valid.", (IArg)param);
      return INVALIDPARAMETER;
  }

  // Check bounds, update value and send notification or indication if possible.
  if ( len <= valMaxLen && len >= valMinLen )
  {
    memcpy(pAttrVal, value, len);
    *pValLen = len; // Update length for read and get.

    if (sendNotiInd)
    {
      Log_info2("Transmitting noti/ind- connHandle %d, %s", (IArg)attrConfig[0].connHandle,
                                                    (IArg)( (attrConfig[0].value==0)?"Noti/ind disabled":
                                                    (attrConfig[0].value==1)?"Notification enabled":
                                                     "Indication enabled" ) );
      // Try to send notification.
      GATTServApp_ProcessCharCfg( attrConfig, pAttrVal, needAuth,
                                  Digital_Input_ServiceAttrTbl, GATT_NUM_ATTRS( Digital_Input_ServiceAttrTbl ),
                                  dis_icall_rsp_task_id,  Digital_Input_Service_ReadAttrCB);
    }
  }
  else
  {
    Log_error3("Length outside bounds: Len: %d MinLen: %d MaxLen: %d.", (IArg)len, (IArg)valMinLen, (IArg)valMaxLen);
    ret = bleInvalidRange;
  }

  return ret;
}


/*
 * DigitalInputService_GetParameter - Get a DigitalInputService parameter.
 *
 *    param - Profile parameter ID
 *    len   - pointer to a variable that contains the maximum length that can be written to *value.
              After the call, this value will contain the actual returned length.
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
bStatus_t DigitalInputService_GetParameter( uint8_t param, uint16_t *len, void *value )
{
  bStatus_t ret = SUCCESS;
  switch ( param )
  {
    default:
      Log_error1("GetParameter: Parameter #%d not valid.", (IArg)param);
      ret = INVALIDPARAMETER;
      break;
  }
  return ret;
}

/*********************************************************************
 * @internal
 * @fn          Digital_Input_Service_findCharParamId
 *
 * @brief       Find the logical param id of an attribute in the service's attr table.
 *
 *              Works only for Characteristic Value attributes and
 *              Client Characteristic Configuration Descriptor attributes.
 *
 * @param       pAttr - pointer to attribute
 *
 * @return      uint8_t paramID (ref Digital_Input_Service.h) or 0xFF if not found.
 */
static uint8_t Digital_Input_Service_findCharParamId(gattAttribute_t *pAttr)
{
  // Is this a Client Characteristic Configuration Descriptor?
  if (ATT_BT_UUID_SIZE == pAttr->type.len && GATT_CLIENT_CHAR_CFG_UUID == *(uint16_t *)pAttr->type.uuid)
    return Digital_Input_Service_findCharParamId(pAttr - 1); // Assume the value attribute precedes CCCD and recurse

  // Is this attribute in "IN1"?
  else if ( ATT_UUID_SIZE == pAttr->type.len && !memcmp(pAttr->type.uuid, dis_IN1UUID, pAttr->type.len))
    return DIS_IN1_ID;

  // Is this attribute in "IN2"?
  else if ( ATT_UUID_SIZE == pAttr->type.len && !memcmp(pAttr->type.uuid, dis_IN2UUID, pAttr->type.len))
    return DIS_IN2_ID;

  // Is this attribute in "IN3"?
  else if ( ATT_UUID_SIZE == pAttr->type.len && !memcmp(pAttr->type.uuid, dis_IN3UUID, pAttr->type.len))
    return DIS_IN3_ID;

  else
    return 0xFF; // Not found. Return invalid.
}

/*********************************************************************
 * @fn          Digital_Input_Service_ReadAttrCB
 *
 * @brief       Read an attribute.
 *
 * @param       connHandle - connection message was received on
 * @param       pAttr - pointer to attribute
 * @param       pValue - pointer to data to be read
 * @param       pLen - length of data to be read
 * @param       offset - offset of the first octet to be read
 * @param       maxLen - maximum length of data to be read
 * @param       method - type of read message
 *
 * @return      SUCCESS, blePending or Failure
 */
static bStatus_t Digital_Input_Service_ReadAttrCB( uint16_t connHandle, gattAttribute_t *pAttr,
                                       uint8_t *pValue, uint16_t *pLen, uint16_t offset,
                                       uint16_t maxLen, uint8_t method )
{
  bStatus_t status = SUCCESS;
  uint16_t valueLen;
  uint8_t paramID = 0xFF;

  // Find settings for the characteristic to be read.
  paramID = Digital_Input_Service_findCharParamId( pAttr );
  switch ( paramID )
  {
    case DIS_IN1_ID:
      valueLen = dis_IN1ValLen;

      Log_info4("ReadAttrCB : %s connHandle: %d offset: %d method: 0x%02x",
                 (IArg)"IN1",
                 (IArg)connHandle,
                 (IArg)offset,
                 (IArg)method);
      /* Other considerations for IN1 can be inserted here */
      break;

    case DIS_IN2_ID:
      valueLen = dis_IN2ValLen;

      Log_info4("ReadAttrCB : %s connHandle: %d offset: %d method: 0x%02x",
                 (IArg)"IN2",
                 (IArg)connHandle,
                 (IArg)offset,
                 (IArg)method);
      /* Other considerations for IN2 can be inserted here */
      break;

    case DIS_IN3_ID:
      valueLen = dis_IN3ValLen;

      Log_info4("ReadAttrCB : %s connHandle: %d offset: %d method: 0x%02x",
                 (IArg)"IN3",
                 (IArg)connHandle,
                 (IArg)offset,
                 (IArg)method);
      /* Other considerations for IN3 can be inserted here */
      break;

    default:
      Log_error0("Attribute was not found.");
      return ATT_ERR_ATTR_NOT_FOUND;
  }
  // Check bounds and return the value
  if ( offset > valueLen )  // Prevent malicious ATT ReadBlob offsets.
  {
    Log_error0("An invalid offset was requested.");
    status = ATT_ERR_INVALID_OFFSET;
  }
  else
  {
    *pLen = MIN(maxLen, valueLen - offset);  // Transmit as much as possible
    memcpy(pValue, pAttr->pValue + offset, *pLen);
  }

  return status;
}

/*********************************************************************
 * @fn      Digital_Input_Service_WriteAttrCB
 *
 * @brief   Validate attribute data prior to a write operation
 *
 * @param   connHandle - connection message was received on
 * @param   pAttr - pointer to attribute
 * @param   pValue - pointer to data to be written
 * @param   len - length of data
 * @param   offset - offset of the first octet to be written
 * @param   method - type of write message
 *
 * @return  SUCCESS, blePending or Failure
 */
static bStatus_t Digital_Input_Service_WriteAttrCB( uint16_t connHandle, gattAttribute_t *pAttr,
                                        uint8_t *pValue, uint16_t len, uint16_t offset,
                                        uint8_t method )
{
  bStatus_t status  = SUCCESS;
  uint8_t   paramID = 0xFF;

  // See if request is regarding a Client Characterisic Configuration
  if (ATT_BT_UUID_SIZE == pAttr->type.len && GATT_CLIENT_CHAR_CFG_UUID == *(uint16_t *)pAttr->type.uuid)
  {
    // Allow notification and indication, but do not check if really allowed per CCCD.
    status = GATTServApp_ProcessCCCWriteReq( connHandle, pAttr, pValue, len,
                                             offset, GATT_CLIENT_CFG_NOTIFY |
                                                     GATT_CLIENT_CFG_INDICATE );
    if (SUCCESS == status && pAppCBs && pAppCBs->pfnCfgChangeCb)
       pAppCBs->pfnCfgChangeCb( connHandle, DIGITAL_INPUT_SERVICE_SERV_UUID,
                                Digital_Input_Service_findCharParamId(pAttr), pValue, len );

     return status;
  }

  // Find settings for the characteristic to be written.
  paramID = Digital_Input_Service_findCharParamId( pAttr );
  switch ( paramID )
  {
    default:
      Log_error0("Attribute was not found.");
      return ATT_ERR_ATTR_NOT_FOUND;
  }
}
